package org.msh.etbm.services.mobile.init;

import org.jboss.seam.Component;
import org.msh.etbm.services.mobile.InitDataGenerator;
import org.msh.etbm.services.mobile.model.*;
import org.msh.tb.entities.*;
import org.msh.tb.entities.enums.RegimenPhase;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 19/4/17.
 */
public class Step2InitGenerator implements InitDataGenerator<AdministrationResponse> {

    @Override
    public AdministrationResponse generate(Tbunit unit) {
        AdministrationResponse resp = new AdministrationResponse();

        resp.setMedicines(convertMedicines());
        resp.setOptions(convertFieldValues());
        resp.setUsers(convertUser(unit));
        resp.setRegimens(convertRegimens());
        resp.setMedicinesRegimen(convertMedicinesRegimen());
        resp.setLaboratories(convertLaboratories());
        resp.setSubstances(convertSubstances());
        resp.setSources(convertSources());

        return resp;
    }

    private EntityManager getEntityManager() {
        return (EntityManager) Component.getInstance("entityManager");
    }

    private List<MedicineData> convertMedicines() {
        List<Medicine> lst = getEntityManager()
                .createQuery("from Medicine where workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<MedicineData> res = new ArrayList<MedicineData>(lst.size());

        for (Medicine med: lst) {
            MedicineData it = new MedicineData();
            it.setId(med.getId());
            it.setName(med.toString());
            it.setAbbrevName(med.getFullAbbrevName());
            res.add(it);
        }
        return res;
    }

    /**
     * Convert the field values
     * @return
     */
    private List<FieldValueData> convertFieldValues() {
        List<FieldValue> lst = getEntityManager()
                .createQuery("from FieldValue where workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<FieldValueData> res = new ArrayList<FieldValueData>(lst.size());

        for (FieldValue fv: lst) {
            FieldValueData it = new FieldValueData();
            it.setId(fv.getId());
            it.setName(fv.getName().getName1());
            it.setField(fv.getField());
            res.add(it);
        }

        return res;
    }


    private List<UserData> convertUser(Tbunit unit) {
        List<User> lst = getEntityManager()
                .createQuery("from User a where exists(select id from UserWorkspace " +
                        "where tbunit.id = :id and user.id = a.id)")
                .setParameter("id", unit.getId())
                .getResultList();

        List<UserData> res = new ArrayList<UserData>(lst.size());

        for (User user: lst) {
            UserData it = new UserData();
            it.setId(user.getId());
            it.setName(user.getName());
            it.setEmail(user.getEmail());
            it.setLogin(user.getLogin());
            it.setPassword(user.getPassword());
            it.setState(user.getState());
            res.add(it);
        }

        return res;
    }

    private List<RegimenData> convertRegimens() {
        List<Regimen> lst = getEntityManager()
                .createQuery("from Regimen r " +
                        "where r.workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<RegimenData> res = new ArrayList<RegimenData>(lst.size());

        for (Regimen regimen: lst) {
            RegimenData it = new RegimenData();
            it.setId(regimen.getId());
            it.setName(regimen.getName());
            it.setCaseClassification(regimen.getCaseClassification());
            it.setEndWeight(regimen.getEndWeight());
            it.setIniWeight(regimen.getIniWeight());

            res.add(it);
        }

        return res;
    }


    private List<MedicineRegimenData> convertMedicinesRegimen() {
        List<Object[]> lst = getEntityManager()
                .createQuery("select id, regimen.id, medicine.id, defaultDoseUnit, defaultFrequency," +
                        "defaultSource.id, monthsTreatment, phase " +
                        "from MedicineRegimen " +
                        "where regimen.workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<MedicineRegimenData> res = new ArrayList<MedicineRegimenData>(lst.size());

        for (Object[] val: lst) {
            MedicineRegimenData item = new MedicineRegimenData();

            item.setId((Integer)val[0]);
            item.setRegimenId((Integer)val[1]);
            item.setMedicineId((Integer)val[2]);
            item.setDefaultDoseUnit((Integer)val[3]);
            item.setDefaultFrequency((Integer)val[4]);
            item.setDefaultSourceId((Integer)val[5]);
            item.setMonthsTreatment((Integer)val[6]);
            item.setPhase((RegimenPhase)val[7]);

            res.add(item);
        }

        return res;
    }

    private List<LaboratoryData> convertLaboratories() {
        List<Laboratory> lst = getEntityManager()
                .createQuery("from Laboratory l " +
                        "where l.workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<LaboratoryData> res = new ArrayList<LaboratoryData>(lst.size());

        for (Laboratory lab: lst) {
            LaboratoryData it = new LaboratoryData();
            it.setId(lab.getId());
            it.setAbbrevName(lab.getAbbrevName());
            it.setName(lab.getName());
            it.setAdminUnitId(lab.getAdminUnit().getId());
            it.setAdminUnitCode(lab.getAdminUnit().getCode());

            res.add(it);
        }

        return res;
    }

    private List<SubstanceData> convertSubstances() {
        List<Substance> lst = getEntityManager()
                .createQuery("from Substance s " +
                        "where s.workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<SubstanceData> res = new ArrayList<SubstanceData>(lst.size());

        for (Substance sub: lst) {
            SubstanceData it = new SubstanceData();
            it.setId(sub.getId());
            it.setName(sub.getName().getName1());
            it.setAbbrevName(sub.getAbbrevName().getName1());

            res.add(it);
        }

        return res;
    }

    private List<SourceData> convertSources() {
        List<Source> lst = getEntityManager()
                .createQuery("from Source s " +
                        "where s.workspace.id = #{defaultWorkspace.id}")
                .getResultList();

        List<SourceData> res = new ArrayList<SourceData>(lst.size());

        for (Source source: lst) {
            SourceData it = new SourceData();
            it.setId(source.getId());
            it.setName(source.getName().getName1());
            it.setAbbrevName(source.getAbbrevName().getName1());

            res.add(it);
        }

        return res;
    }
}
